%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Stability Regions of Numerical Methods for Solving Ordinary Differential
% Equations

% The aim of this exercise is to plot the stability regions for some of the
% explicit Runge-Kutta methods that we have seen in class and during the
% last computational session.
% This time I decided to give you a script to complete. This will be the
% main driver of your code. You should complete this script, whenever you
% find three dots "..." and code the function "computeRKStabilityRegion"
% (in a separate script) that computes a discretized version of the
% stability region for any given method with RK matrix A, weights b, and
% meshgrid Z. In the function "computeRKStabilityRegion", you should use
% the expression for the stability function R(z) seen in class to compute
% a discretized version of the stability regions for each RK method below
% (Explicit Euler, Heun, RK4, and Dormand-Prince).

% Created:     2025.12.02
% Last change: 2025.12.02
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all; clear; clc;
addpath(genpath('.'))
% Set latex as the intepreter for the text in the plot and default axes
% fontsize
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );   % or 14
%--------------------------------------------------------------------------
% Define some custom colors:
yellow = [0.894, 0.671, 0.094];
green = [0.667, 0.706, 0.118];
blue = [0.239, 0.376, 0.655];
red = [0.827, 0.341, 0.306];
orange = [0.870, 0.443, 0.137];
%--------------------------------------------------------------------------
% Data
% N = grid resolution
N = ...;

% Grid in complex plane.
% Here you should create a grid Z (a matrix) that discretizes the complex
% plane. This matrix Z will be an input argument of your function 
% "computeRKStabilityRegion"
xrange = ...;
yrange = ...;
x = linspace(..., ..., ...);
y = linspace(..., ..., ...);
[X, Y] = meshgrid(x, y);
Z = ...;

%--------------------------------------------------------------------------
% Compute stability functions
% Explicit Euler
A = 0;
b = 1;
R_EE = computeRKStabilityRegion( ... );

% Heun
A = [0 0;
     1 0];
b = [1/2;
     1/2];
R_Heun = computeRKStabilityRegion( ... );

% Classical RK4
A = [0   0   0 0;
     1/2 0   0 0;
     0   1/2 0 0;
     0   0   1 0];
b = [1/6; 1/3; 1/3; 1/6];
R_RK4 = computeRKStabilityRegion( ... );

%  Dormand–Prince RK45
A = [0               0               0               0               0               0               0;
     1/5             0               0               0               0               0               0;
     3/40            9/40            0               0               0               0               0;
     44/45          -56/15           32/9            0               0               0               0;
     19372/6561     -25360/2187      64448/6561     -212/729         0               0               0;
     9017/3168      -355/33          46732/5247      49/176         -5103/18656      0               0;
     35/384          0               500/1113        125/192        -2187/6784      11/84           0];

% Primary weights (i.e., those for the 5th order)
w1 = [35/384; 0; 500/1113; 125/192; -2187/6784; 11/84; 0];   % NOTE: must be 7 components

R_DP = computeRKStabilityRegion( ... );

%--------------------------------------------------------------------------
% Plot: tiled layout
figure('Position',[200 200 950 400]);
tl = tiledlayout(1,4);
title(tl, 'Stability Regions of Explicit Runge–Kutta Methods', 'FontSize', 16);

% Explicit Euler
nexttile;
contourf(..., ..., ..., [0 1], 'LineStyle','none');
axis equal tight;
title('Explicit Euler');
xlabel('Re(z)');
ylabel('Im(z)');
grid on;

% Heun
nexttile;
contourf(...);
...

% Classical RK4
nexttile;
...

% Dormand-Prince
nexttile;
...

% For changing the color of the regions:
colormap([red; 1 1 1]);