%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Numerical integration of ODEs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all; clear; clc;
addpath(genpath('.'))
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 18 );
%--------------------------------------------------------------------------

% The Brusselator is a theoretical model for a type of autocatalytic
% reaction. It was proposed by Ilya Prigogine and his collaborators at the
% Université Libre de Bruxelles.
% Its name is a portmanteau of Brussels and oscillator. 

%--------------------------------------------------------------------------
% Data of the problem
% RHS
fun = @(t,y) brusselator(t,y);

% Initial conditions
y(1) = 1.5;
y(2) = 3;

% Other parameters
t0 = 0;
tf = 20;
h0 = 0.1;     % Initial step size
Tol = 1e-6;   % Tolerance for the solver
y0 = y';      % Initial conditions as a column vector
%--------------------------------------------------------------------------

% Compute the numerical solution
[ gridpoints, sol ] = RK45(fun, t0, tf, y0, h0, Tol);

%--------------------------------------------------------------------------
% Plot the solution
figure(1);
set(gcf,'units','normalized','position',[0 .25 1 .5])
plot(gridpoints, sol(1,:), 'ob-', 'LineWidth', 2, 'MarkerSize', 10 );
hold on;
grid on;
plot(gridpoints, sol(2,:), '^r-', 'LineWidth', 2, 'MarkerSize', 10 );
xlabel('Time ($t$)');
ylabel('Solution ($y$)');
legend('$y_{1}$', '$y_{2}$', 'Location', 'NW' );
% title('Numerical Solution of the Brusselator ODE');

% % Plot in phase space
% figure(2);
% plot( sol(1,:), sol(2,:), 'sk-', 'LineWidth', 2, 'MarkerSize', 10 );
% grid on
% xlabel('$y_{1}$');
% ylabel('$y_{2}$');