%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EXERCISE
% Implicit Runge-Kutta Methods for Stiff ODEs.
% Radau IIa method with inner simplified Newton method for solving the
% Runge-Kutta equations. Test case: Van der Pol equation.
% Created:     2026.01.05
% Last change: 2026.01.06
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all; clear; clc;
addpath(genpath('.'))
set( 0, 'defaultAxesTickLabelInterpreter', 'latex' );
set( 0, 'defaultLegendInterpreter',        'latex' );
set( 0, 'defaultTextInterpreter',          'latex' );
set( 0, 'defaultAxesFontSize', 16 );

%--------------------------------------------------------------------------
% Data
%--------------------------------------------------------------------------
% Parameters for the Van der Pol equation
eps = 1e-4;
t0 = 0;
tf = 5;

% Initial conditions
y0 = [2; -0.66];

% Parameters for the RK method
h = 1e-3;    % fixed step size
N = round((tf - t0)/h);

% Parameters for the simplified Newton method
options_newton.tol = 1e-10;
options_newton.maxiter = 20;
%--------------------------------------------------------------------------

% Initializations
t = t0;
y = y0;

T = zeros(N+1,1);
Y = zeros(N+1,2);
T(1) = t;
Y(1,:) = y';

for k = 1:N
    y = radau5_step( t, y, h, eps, options_newton );
    t = t + h;
    T(k+1) = t;
    Y(k+1,:) = y';
end

%--------------------------------------------------------------------------
% PLOTS
%--------------------------------------------------------------------------
figure
plot( T, Y(:,1), 'LineWidth', 1.5 )
hold on
xlim([t0, tf]);
% plot(T,Y(:,2),'LineWidth',1.5)
xlabel('$t$');
ylabel('$y_{1}$');
% legend('$ y_{1} $');
title('Van der Pol equation, Radau IIA (order 5)')
grid on 