function J = vdp_jac( t, y, eps )

% function J = vdp_jac( t, y, eps )
% Purpose: Returns the Jacobian matrix, computed analytically of the\
%          Van der Pol equation RHS.
% Created:     2025.12.05
% Last change: 2025.12.07

J = zeros(2,2);
J(1,1) = 0;
J(1,2) = 1;

J(2,1) = (-2*y(1)*y(2) - 1)/eps;
J(2,2) = (1 - y(1)^2)/eps;

end