function [ y ] = RK4_NA( f, y0, t, h, N )

% function [ y ] = RK4_NA( f, y0, t, h, N )
% This function uses the Runge-Kutta 4 stages method to solve numerically a
% linear ODE of the type "y' = f(t,y)" for a given initial condition "y0".
% The numerical solution is obtained on a uniform mesh of "N+1" points
% and size "h".
% INPUT:
% f  : function handle for the RHS of the ODE;
% y0 : initial condition;
% t  : vector of discretized time;
% h  : mesh size;
% N  : number of mesh points.
% OUTPUT:
% y  : discrete solution.

% Initialize "y"
y = zeros(N+1,1);

% Assign initial condition
y(1) = y0;

% Compute the discrete approximation
for j = 1:N
    k1 = f( t(j), y(j) );
    k2 = f( t(j) + h/2, y(j) + (h/2) * k1 );
    k3 = f( t(j) + h/2, y(j) + (h/2) * k2 );
    k4 = f( t(j) + h, y(j) + h * k3);
    y(j+1) = y(j) + (h/6) * ( k1 + 2*k2 + 2*k3 + k4 );
end

end